/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon;

import com.quantumdata.busmon.CommandAction;
import com.quantumdata.busmon.ComponentFactory;
import com.quantumdata.busmon.ExtensionFilter;
import com.quantumdata.busmon.PortAction;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.ToggleAction;
import com.quantumdata.busmon.parser.Packet;
import com.quantumdata.busmon.parser.Parser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.security.AccessControlException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;

public final class MainAppFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 12;
    private JMenuBar jMenuBar;
    private JMenu jMenuCEC;
    private JMenu jMenuCECPort;
    private JMenu jMenuDDC;
    private JMenu jMenuDDCPort;
    private JMenu jMenuDisplay;
    private JMenu jMenuDisplayPort;
    private JMenu jMenuFile;
    private JMenu jMenuOptions;
    private JMenu jMenuSearch;
    private JTextArea jPacketDetails;
    private JTextArea jPacketRaw;
    private JTable jPacketTable;
    private JScrollPane jScrollDetails;
    private JScrollPane jScrollPaneTable;
    private JScrollPane jScrollRaw;
    private JToolBar jStatusBar;
    private JTextField jTextConnection;
    private JTextField jTextPacketCount;
    private JToolBar jToolBar;
    public static CommandAction connectAction;
    public static CommandAction newAction;
    public static CommandAction openAction;
    public static CommandAction saveAsAction;
    public static CommandAction saveAction;
    public static CommandAction saveToHTMLAction;
    public static CommandAction saveEDIDAction;
    public static CommandAction quitAction;
    public static CommandAction findAction;
    public static CommandAction findNextAction;
    public static CommandAction sendCommandAction;
    public static CommandAction aboutAction;
    public static CommandAction colorsAction;
    public static ToggleAction highlightAction;
    public static ToggleAction toggleCaptureAction;
    public static ToggleAction togglePauseAction;
    public static ToggleAction togglePedanticAction;
    public static ToggleAction toggleStateTraceAction;
    public static ToggleAction filterEDIDAction;
    public static ToggleAction filterDDCCIAction;
    public static ToggleAction filterHDCPAction;
    public static ToggleAction filterCECAction;
    public static ToggleAction filterDPCDAction;
    public static ToggleAction filterEventsAction;
    public static ToggleAction filterOtherAction;
    public static ToggleAction errorsOnlyAction;
    public static ToggleAction deltaTimeAction;
    public static ToggleAction confirmExitAction;
    public static ToggleAction confirmNewAction;
    public static ToggleAction enable5VoltTPAAction;
    static int selectedRow;
    static JDialog findDialog;
    static JDialog connectDialog;
    static JDialog colorDialog;
    static JDialog sendCommandDialog;
    static File openFile;
    static JFileChooser files;
    public static Vector<PortAction> analyzerDDCPorts;
    public static int analyzerDDCPort;
    public static int numDDCPorts;
    private ButtonGroup buttonGroupDDCPorts;
    public static Vector<PortAction> analyzerCECPorts;
    public static int analyzerCECPort;
    public static int numCECPorts;
    private ButtonGroup buttonGroupCECPorts;
    public static Vector<PortAction> analyzerDisplayPorts;
    public static int analyzerDisplayPort;
    public static int numDisplayPorts;
    private ButtonGroup buttonGroupDisplayPorts;
    public static int deltaTimeStartIndex;
    private static int prevSelectedIndex;

    public MainAppFrame() {
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.initComponents();
        this.setBounds(30, 30, dimension.width - 60, dimension.height - 60);
        connectAction = new CommandAction("Connect to Instrument...", CommandAction.Command.CONNECT, KeyStroke.getKeyStroke(67, 128), 67);
        connectAction.putValue("SmallIcon", new ImageIcon(MainAppFrame.class.getResource("resources/connect.gif")));
        newAction = new CommandAction("New Trace", CommandAction.Command.NEW, KeyStroke.getKeyStroke(78, 128), 78);
        newAction.putValue("SmallIcon", new ImageIcon(MainAppFrame.class.getResource("resources/new.gif")));
        openAction = new CommandAction("Open Saved Trace...", CommandAction.Command.OPEN, KeyStroke.getKeyStroke(79, 128), 79);
        openAction.putValue("SmallIcon", new ImageIcon(MainAppFrame.class.getResource("resources/open.gif")));
        saveAsAction = new CommandAction("Save Trace As...", CommandAction.Command.SAVEAS, KeyStroke.getKeyStroke(65, 128), 65);
        saveAsAction.putValue("SmallIcon", new ImageIcon(MainAppFrame.class.getResource("resources/save.gif")));
        saveAction = new CommandAction("Save Trace...", CommandAction.Command.SAVE, KeyStroke.getKeyStroke(83, 128), 83);
        saveAction.putValue("SmallIcon", new ImageIcon(MainAppFrame.class.getResource("resources/save.gif")));
        saveToHTMLAction = new CommandAction("Save to HTML", CommandAction.Command.SAVETOHTML, KeyStroke.getKeyStroke(72, 128), 72);
        saveToHTMLAction.putValue("SmallIcon", new ImageIcon(MainAppFrame.class.getResource("resources/save.gif")));
        saveEDIDAction = new CommandAction("Save EDID From Trace", CommandAction.Command.SAVEEDIDFROMTRACE, KeyStroke.getKeyStroke(69, 128), 69);
        saveEDIDAction.putValue("SmallIcon", new ImageIcon(MainAppFrame.class.getResource("resources/save.gif")));
        if (Sniffer.program != null) {
            quitAction = new CommandAction("Quit", CommandAction.Command.QUIT, KeyStroke.getKeyStroke(81, 128), 81);
        }
        this.jMenuFile.add(new JMenuItem(connectAction));
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(new JMenuItem(newAction));
        this.jMenuFile.add(new JMenuItem(openAction));
        this.jMenuFile.add(new JMenuItem(saveAsAction));
        this.jMenuFile.add(new JMenuItem(saveAction));
        saveAction.setEnabled(false);
        this.jMenuFile.add(new JMenuItem(saveToHTMLAction));
        this.jMenuFile.add(new JMenuItem(saveEDIDAction));
        saveEDIDAction.setEnabled(false);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(new JMenuItem(quitAction));
        findAction = new CommandAction("Find...", CommandAction.Command.FIND, KeyStroke.getKeyStroke(70, 128), 70);
        findNextAction = new CommandAction("Find Next", CommandAction.Command.FINDNEXT, KeyStroke.getKeyStroke(114, 0), 78);
        highlightAction = new ToggleAction("Highlight Matches", "Highlight Matches", ToggleAction.Toggle.HIGHLIGHT);
        highlightAction.putValue("ACCELERATOR_KEY", KeyStroke.getKeyStroke(72, 128));
        highlightAction.putValue("MNEMONIC_KEY", 72);
        this.jMenuSearch.add(new JMenuItem(findAction));
        this.jMenuSearch.add(new JMenuItem(findNextAction));
        sendCommandAction = new CommandAction("Send Command...", CommandAction.Command.SENDCOMMAND);
        sendCommandAction.putValue("MNEMONIC_KEY", 83);
        colorsAction = new CommandAction("Colors...", CommandAction.Command.COLORS);
        colorsAction.putValue("MNEMONIC_KEY", 67);
        confirmExitAction = new ToggleAction("Confirm on Exit", "Confirm on Exit", ToggleAction.Toggle.CONFIRMEXIT);
        confirmExitAction.putValue("MNEMONIC_KEY", 88);
        confirmNewAction = new ToggleAction("Confirm on New Trace", "Confirm on New Trace", ToggleAction.Toggle.CONFIRMNEW);
        confirmNewAction.putValue("MNEMONIC_KEY", 78);
        togglePedanticAction = new ToggleAction("DEBUG: Uber-Pedantic Debug Mode", "DEBUG: Uber-Pedantic Debug Mode", ToggleAction.Toggle.PEDANTIC);
        toggleStateTraceAction = new ToggleAction("DEBUG: Show I2C State Machine Trace", "DEBUG: Show I2C State Machine Trace", ToggleAction.Toggle.STATETRACE);
        aboutAction = new CommandAction("About...", CommandAction.Command.ABOUT);
        aboutAction.putValue("MNEMONIC_KEY", 65);
        toggleCaptureAction = new ToggleAction("Capture", "Stop", ToggleAction.Toggle.CAPTURE, false, MainAppFrame.class.getResource("resources/red-off.gif"), MainAppFrame.class.getResource("resources/red-on.gif"));
        toggleCaptureAction.putValue("MNEMONIC_KEY", 116);
        togglePauseAction = new ToggleAction("Pause", "PAUSED", ToggleAction.Toggle.PAUSE, false, MainAppFrame.class.getResource("resources/yellow-off.gif"), MainAppFrame.class.getResource("resources/yellow-on.gif"));
        filterEDIDAction = new ToggleAction("EDID", "EDID", ToggleAction.Toggle.EDID, true, MainAppFrame.class.getResource("resources/green-off.gif"), MainAppFrame.class.getResource("resources/green-on.gif"));
        filterDDCCIAction = new ToggleAction("DDC/CI", "DDC/CI", ToggleAction.Toggle.DDCCI, true, MainAppFrame.class.getResource("resources/green-off.gif"), MainAppFrame.class.getResource("resources/green-on.gif"));
        filterHDCPAction = new ToggleAction("HDCP", "HDCP", ToggleAction.Toggle.HDCP, true, MainAppFrame.class.getResource("resources/green-off.gif"), MainAppFrame.class.getResource("resources/green-on.gif"));
        filterCECAction = new ToggleAction("CEC", "CEC", ToggleAction.Toggle.CEC, true, MainAppFrame.class.getResource("resources/green-off.gif"), MainAppFrame.class.getResource("resources/green-on.gif"));
        filterDPCDAction = new ToggleAction("DPCD", "DPCD", ToggleAction.Toggle.DPCD, true, MainAppFrame.class.getResource("resources/green-off.gif"), MainAppFrame.class.getResource("resources/green-on.gif"));
        filterEventsAction = new ToggleAction("Events", "Events", ToggleAction.Toggle.EVENTS, true, MainAppFrame.class.getResource("resources/green-off.gif"), MainAppFrame.class.getResource("resources/green-on.gif"));
        filterOtherAction = new ToggleAction("Others", "Others", ToggleAction.Toggle.OTHERS, true, MainAppFrame.class.getResource("resources/green-off.gif"), MainAppFrame.class.getResource("resources/green-on.gif"));
        errorsOnlyAction = new ToggleAction("ALL Packets", "ERRORS ONLY", ToggleAction.Toggle.ERRORSONLY, false, MainAppFrame.class.getResource("resources/yellow-off.gif"), MainAppFrame.class.getResource("resources/yellow-on.gif"));
        deltaTimeAction = new ToggleAction("DELTA mode", "CUMULATIVE mode", ToggleAction.Toggle.DELTATIME, false, MainAppFrame.class.getResource("resources/yellow-off.gif"), MainAppFrame.class.getResource("resources/yellow-on.gif"));
        enable5VoltTPAAction = new ToggleAction("Enable 5-Volt TPA", "Enable 5-Volt TPA", ToggleAction.Toggle.TPA5VOLT);
        enable5VoltTPAAction.setEnabled(false);
        this.jMenuOptions.add(ComponentFactory.getCheckBoxMenuItem(enable5VoltTPAAction));
        this.jMenuOptions.addSeparator();
        this.jMenuOptions.add(new JMenuItem(sendCommandAction));
        this.jMenuOptions.addSeparator();
        this.jMenuOptions.add(new JMenuItem(aboutAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(toggleCaptureAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(togglePauseAction));
        this.jToolBar.addSeparator();
        JButton jButton = new JButton(connectAction);
        jButton.setText(null);
        jButton.setToolTipText("Connect...");
        this.jToolBar.add(jButton);
        jButton = new JButton(newAction);
        jButton.setText(null);
        jButton.setToolTipText("New");
        this.jToolBar.add(jButton);
        jButton = new JButton(openAction);
        jButton.setText(null);
        jButton.setToolTipText("Open Trace...");
        this.jToolBar.add(jButton);
        jButton = new JButton(saveAsAction);
        jButton.setText(null);
        jButton.setToolTipText("Save Trace As...");
        this.jToolBar.add(jButton);
        jButton = new JButton(saveAction);
        jButton.setText(null);
        jButton.setToolTipText("Save Trace...");
        this.jToolBar.add(jButton);
        this.jToolBar.addSeparator();
        this.jToolBar.add(ComponentFactory.getToggleButton(filterEDIDAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(filterDDCCIAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(filterHDCPAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(filterCECAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(filterDPCDAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(filterEventsAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(filterOtherAction));
        this.jToolBar.addSeparator();
        this.jToolBar.add(ComponentFactory.getToggleButton(errorsOnlyAction));
        this.jToolBar.add(ComponentFactory.getToggleButton(deltaTimeAction));
        this.jScrollDetails.getViewport().setView(this.jPacketDetails);
        this.jScrollRaw.getViewport().setView(this.jPacketRaw);
        try {
            files = new JFileChooser();
            openFile = null;
        }
        catch (AccessControlException accessControlException) {
            JOptionPane.showMessageDialog(Sniffer.window, "The Java Security Manager is preventing the ACA from running.");
            System.exit(1);
        }
        this.setUpPacketTable();
        this.addWindowListener(new WindowHandler());
        this.updateConnectionInformation();
    }

    void updatePortsMenus() {
        JRadioButtonMenuItem jRadioButtonMenuItem;
        int n;
        this.jMenuDDCPort.removeAll();
        this.jMenuCECPort.removeAll();
        this.jMenuDisplayPort.removeAll();
        this.buttonGroupDDCPorts = new ButtonGroup();
        this.buttonGroupCECPorts = new ButtonGroup();
        this.buttonGroupDisplayPorts = new ButtonGroup();
        if (analyzerDDCPorts != null) {
            for (n = 0; n < analyzerDDCPorts.size(); ++n) {
                jRadioButtonMenuItem = (JRadioButtonMenuItem)ComponentFactory.getRadioMenuItem(analyzerDDCPorts.get(n));
                this.buttonGroupDDCPorts.add(jRadioButtonMenuItem);
                this.jMenuDDCPort.add(jRadioButtonMenuItem);
                if (n == 0) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                analyzerDDCPort = 0;
            }
            this.jMenuDDCPort.setEnabled(true);
        } else {
            this.jMenuDDCPort.setEnabled(false);
        }
        if (analyzerCECPorts != null) {
            for (n = 0; n < analyzerCECPorts.size(); ++n) {
                jRadioButtonMenuItem = (JRadioButtonMenuItem)ComponentFactory.getRadioMenuItem(analyzerCECPorts.get(n));
                this.buttonGroupCECPorts.add(jRadioButtonMenuItem);
                this.jMenuCECPort.add(jRadioButtonMenuItem);
                if (n == 0) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                analyzerCECPort = 0;
            }
            this.jMenuCECPort.setEnabled(true);
        } else {
            this.jMenuCECPort.setEnabled(false);
        }
        if (analyzerDisplayPorts != null) {
            for (n = 0; n < analyzerDisplayPorts.size(); ++n) {
                jRadioButtonMenuItem = (JRadioButtonMenuItem)ComponentFactory.getRadioMenuItem(analyzerDisplayPorts.get(n));
                this.buttonGroupDisplayPorts.add(jRadioButtonMenuItem);
                this.jMenuDisplayPort.add(jRadioButtonMenuItem);
                if (n == 0) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                analyzerDisplayPort = 0;
            }
            this.jMenuDisplayPort.setEnabled(true);
        } else {
            this.jMenuDisplayPort.setEnabled(false);
        }
    }

    public void setPauseStatus(boolean bl) {
        if (!bl) {
            Parser.packets.updateFilteredTrace();
        }
    }

    public void setCaptureStatus(boolean bl) {
        if (!bl) {
            Sniffer.parser.setCapturing(false);
            this.jMenuDDCPort.setEnabled(true);
            this.jMenuCECPort.setEnabled(true);
            this.jMenuDisplayPort.setEnabled(true);
            newAction.setEnabled(true);
            openAction.setEnabled(true);
        } else {
            Sniffer.parser.setCapturePortDDC(analyzerDDCPort);
            Sniffer.parser.setCapturePortCEC(analyzerCECPort);
            Sniffer.parser.setCaptureDisplayPort(analyzerDisplayPort);
            Sniffer.parser.setCapturing(true);
            this.jMenuDDCPort.setEnabled(false);
            this.jMenuCECPort.setEnabled(false);
            this.jMenuDisplayPort.setEnabled(false);
            newAction.setEnabled(false);
            openAction.setEnabled(false);
        }
    }

    public void updateConnectionInformation() {
        toggleCaptureAction.setEnabled(Parser.instrument.isConnected());
        if (Parser.instrument.isConnected()) {
            this.setStatusBar(String.format("Connected to %s: %d I2C, %d CEC, %d DisplayPort devices available for monitoring", Parser.connection.getName(), numDDCPorts, numCECPorts, numDisplayPorts));
        } else {
            this.setStatusBar("Not Connected");
            analyzerDDCPorts = null;
            enable5VoltTPAAction.setEnabled(false);
        }
        this.updatePortsMenus();
    }

    void setUpPacketTable() {
        this.jPacketTable.setModel(Parser.packets);
        this.jPacketTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.jPacketTable.getColumnModel().getColumn(1).setPreferredWidth(32);
        this.jPacketTable.getColumnModel().getColumn(1).setResizable(false);
        this.jPacketTable.getColumnModel().getColumn(2).setPreferredWidth(140);
        this.jPacketTable.getColumnModel().getColumn(3).setPreferredWidth(140);
        this.jPacketTable.getColumnModel().getColumn(4).setPreferredWidth(70);
        this.jPacketTable.getColumnModel().getColumn(5).setPreferredWidth(120);
        this.jPacketTable.getColumnModel().getColumn(6).setPreferredWidth(50);
        this.jPacketTable.getColumnModel().getColumn(7).setPreferredWidth(50);
        this.jPacketTable.getColumnModel().getColumn(8).setPreferredWidth(400);
        this.jPacketTable.getSelectionModel().setSelectionMode(0);
        this.jPacketTable.getSelectionModel().addListSelectionListener(new PacketListListener());
        this.jPacketTable.getModel().addTableModelListener(new PacketTraceListener());
        Parser.packets.refresh();
    }

    private void initComponents() {
        this.jToolBar = new JToolBar();
        this.jScrollDetails = new JScrollPane();
        this.jPacketDetails = new JTextArea();
        this.jScrollRaw = new JScrollPane();
        this.jPacketRaw = new JTextArea();
        this.jStatusBar = new JToolBar();
        this.jTextConnection = new JTextField();
        this.jTextPacketCount = new JTextField();
        this.jScrollPaneTable = new JScrollPane();
        this.jPacketTable = new JTable();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuDDC = new JMenu();
        this.jMenuDDCPort = new JMenu();
        this.jMenuCEC = new JMenu();
        this.jMenuCECPort = new JMenu();
        this.jMenuDisplay = new JMenu();
        this.jMenuDisplayPort = new JMenu();
        this.jMenuSearch = new JMenu();
        this.jMenuOptions = new JMenu();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Quantum Data Auxiliary Channel Analyzer");
        this.jToolBar.setFloatable(false);
        this.jToolBar.setMaximumSize(new Dimension(13, 32));
        this.jToolBar.setMinimumSize(new Dimension(13, 32));
        this.jToolBar.setPreferredSize(new Dimension(13, 32));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 5.0;
        this.getContentPane().add((Component)this.jToolBar, gridBagConstraints);
        this.jScrollDetails.setBorder(new TitledBorder("Details"));
        this.jScrollDetails.setMinimumSize(new Dimension(37, 75));
        this.jScrollDetails.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPacketDetails.setEditable(false);
        this.jPacketDetails.setFont(new Font("Monospaced", 0, 12));
        this.jPacketDetails.setLineWrap(true);
        this.jPacketDetails.setWrapStyleWord(true);
        this.jScrollDetails.setViewportView(this.jPacketDetails);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 60.0;
        gridBagConstraints.weighty = 30.0;
        this.getContentPane().add((Component)this.jScrollDetails, gridBagConstraints);
        this.jScrollRaw.setBorder(new TitledBorder("Data"));
        this.jScrollRaw.setMinimumSize(new Dimension(37, 75));
        this.jScrollRaw.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPacketRaw.setEditable(false);
        this.jPacketRaw.setFont(new Font("Monospaced", 0, 12));
        this.jScrollRaw.setViewportView(this.jPacketRaw);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 40.0;
        gridBagConstraints.weighty = 30.0;
        this.getContentPane().add((Component)this.jScrollRaw, gridBagConstraints);
        this.jStatusBar.setFloatable(false);
        this.jStatusBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 28));
        this.jStatusBar.setMinimumSize(new Dimension(13, 28));
        this.jStatusBar.setPreferredSize(new Dimension(13, 28));
        this.jTextConnection.setEditable(false);
        this.jTextConnection.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2))));
        this.jTextConnection.setFocusable(false);
        this.jTextConnection.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        this.jTextConnection.setMinimumSize(new Dimension(8, 24));
        this.jTextConnection.setPreferredSize(new Dimension(93, 24));
        this.jStatusBar.add(this.jTextConnection);
        this.jTextPacketCount.setEditable(false);
        this.jTextPacketCount.setHorizontalAlignment(4);
        this.jTextPacketCount.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2))));
        this.jTextPacketCount.setFocusable(false);
        this.jTextPacketCount.setMaximumSize(new Dimension(192, 24));
        this.jTextPacketCount.setMinimumSize(new Dimension(192, 24));
        this.jTextPacketCount.setPreferredSize(new Dimension(192, 24));
        this.jStatusBar.add(this.jTextPacketCount);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 5.0;
        this.getContentPane().add((Component)this.jStatusBar, gridBagConstraints);
        this.jScrollPaneTable.setBorder(new TitledBorder("Packets"));
        this.jPacketTable.setFont(new Font("Monospaced", 1, 12));
        this.jPacketTable.setModel(Parser.packets);
        this.jPacketTable.setAutoResizeMode(0);
        this.jScrollPaneTable.setViewportView(this.jPacketTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 60.0;
        this.getContentPane().add((Component)this.jScrollPaneTable, gridBagConstraints);
        this.jMenuBar.setBorder(null);
        this.jMenuFile.setMnemonic('F');
        this.jMenuFile.setText("File");
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuDDC.setMnemonic('D');
        this.jMenuDDC.setText("DDC");
        this.jMenuDDCPort.setMnemonic('P');
        this.jMenuDDCPort.setText("Port");
        this.jMenuDDCPort.setEnabled(false);
        this.jMenuDDC.add(this.jMenuDDCPort);
        this.jMenuBar.add(this.jMenuDDC);
        this.jMenuCEC.setMnemonic('C');
        this.jMenuCEC.setText("CEC");
        this.jMenuCECPort.setMnemonic('P');
        this.jMenuCECPort.setText("Port");
        this.jMenuCECPort.setEnabled(false);
        this.jMenuCEC.add(this.jMenuCECPort);
        this.jMenuBar.add(this.jMenuCEC);
        this.jMenuDisplay.setMnemonic('P');
        this.jMenuDisplay.setText("DisplayPort");
        this.jMenuDisplayPort.setMnemonic('P');
        this.jMenuDisplayPort.setText("Port");
        this.jMenuDisplayPort.setEnabled(false);
        this.jMenuDisplay.add(this.jMenuDisplayPort);
        this.jMenuBar.add(this.jMenuDisplay);
        this.jMenuSearch.setMnemonic('S');
        this.jMenuSearch.setText("Search");
        this.jMenuBar.add(this.jMenuSearch);
        this.jMenuOptions.setMnemonic('O');
        this.jMenuOptions.setText("Options");
        this.jMenuBar.add(this.jMenuOptions);
        this.setJMenuBar(this.jMenuBar);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 688) / 2, (dimension.height - 480) / 2, 688, 480);
    }

    public static File showFileDialog(String string, String string2, String string3, String string4, String string5, File file) {
        File file2 = null;
        files.setDialogTitle(string);
        files.setApproveButtonText(string2);
        files.setApproveButtonToolTipText(string3);
        files.setFileSelectionMode(0);
        files.resetChoosableFileFilters();
        ExtensionFilter extensionFilter = new ExtensionFilter(string4, string5);
        files.addChoosableFileFilter(extensionFilter);
        files.setFileFilter(extensionFilter);
        files.rescanCurrentDirectory();
        files.setSelectedFile(file);
        int n = files.showDialog(Sniffer.window, null);
        if (n == 0) {
            file2 = files.getSelectedFile();
        }
        return file2;
    }

    ListSelectionModel getTableSelectionModel() {
        return this.jPacketTable.getSelectionModel();
    }

    JScrollPane getTableScrollPane() {
        return this.jScrollPaneTable;
    }

    JTable getTable() {
        return this.jPacketTable;
    }

    public void setStatusBar(String string) {
        this.jTextConnection.setText(string);
    }

    static String getTraceFilename() {
        String string = "default.BMtrace";
        return string;
    }

    static String getCurrentTraceFilename() {
        return openFile.getName();
    }

    static String getHtmlFilename() {
        String string = "default.html";
        return string;
    }

    public void saveToHTML(File file) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body><TABLE border=1>");
        stringBuffer.append("<tr>");
        int n2 = this.jPacketTable.getColumnCount();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("<td><b>");
            stringBuffer.append(Parser.packets.getColumnName(n));
            stringBuffer.append("</b></td>");
        }
        stringBuffer.append("<td><b>Raw data</b></td>");
        stringBuffer.append("</tr>");
        n = this.jPacketTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("<tr>");
            for (int j = 0; j < n2; ++j) {
                Object object = this.jPacketTable.getValueAt(i, j);
                stringBuffer.append("<td>");
                stringBuffer.append(object.toString());
                stringBuffer.append("</td>");
            }
            Packet packet = Parser.packets.getPacket(i);
            stringBuffer.append("<td>" + packet.getHexString() + "</td>");
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</TABLE></body></html>");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(stringBuffer.toString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.getParent(), "Error writing report to selected file");
        }
    }

    public void updateDeltaTimeColumnName() {
        JScrollBar jScrollBar = this.jScrollPaneTable.getVerticalScrollBar();
        int n = jScrollBar.getValue();
        String string = "Delta Time";
        if (deltaTimeAction.isTrue()) {
            string = "Cumulative Time";
        }
        int n2 = this.jPacketTable.convertColumnIndexToView(3);
        TableColumnModel tableColumnModel = this.jPacketTable.getColumnModel();
        tableColumnModel.getColumn(n2).setHeaderValue(string);
        this.jPacketTable.getTableHeader().repaint();
        Parser.packets.refresh();
        if (deltaTimeStartIndex != -1) {
            this.jPacketTable.addRowSelectionInterval(deltaTimeStartIndex, deltaTimeStartIndex);
        }
        this.jPacketTable.requestFocus();
        jScrollBar.setValue(n);
    }

    public static void setEnableSaveEDIDOption(boolean bl) {
        saveEDIDAction.setEnabled(bl);
    }

    static {
        selectedRow = -1;
        numDDCPorts = 0;
        numCECPorts = 0;
        numDisplayPorts = 0;
        deltaTimeStartIndex = -1;
        prevSelectedIndex = -1;
    }

    private class PacketListListener
    implements ListSelectionListener {
        private PacketListListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                MainAppFrame.this.jPacketDetails.setText("No packets selected.");
                MainAppFrame.this.jPacketRaw.setText("");
            } else {
                selectedRow = listSelectionModel.getLeadSelectionIndex();
                Packet packet = Parser.packets.getPacket(selectedRow);
                MainAppFrame.this.jPacketDetails.setText(packet.getExtendedDetails());
                MainAppFrame.this.jPacketRaw.setText(packet.getHex());
                MainAppFrame.this.jScrollRaw.getViewport().setViewPosition(new Point(0, 0));
                deltaTimeStartIndex = selectedRow;
                if (prevSelectedIndex == deltaTimeStartIndex) {
                    return;
                }
                prevSelectedIndex = deltaTimeStartIndex;
                if (deltaTimeAction.isTrue()) {
                    int n = MainAppFrame.this.jScrollPaneTable.getVerticalScrollBar().getValue();
                    Parser.packets.refresh();
                    MainAppFrame.this.jPacketTable.addRowSelectionInterval(deltaTimeStartIndex, deltaTimeStartIndex);
                    MainAppFrame.this.jScrollPaneTable.getVerticalScrollBar().setValue(n);
                }
            }
        }
    }

    private class PacketTraceListener
    implements TableModelListener {
        private PacketTraceListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            MainAppFrame.this.jTextPacketCount.setText(Parser.packets.getPacketCount() + " packets (" + Parser.packets.getFilteredCount() + " shown)");
            if (selectedRow == Parser.packets.getRowCount() - 2) {
                MainAppFrame.this.jPacketTable.getSelectionModel().setLeadSelectionIndex(Parser.packets.getRowCount() - 1);
            }
            MainAppFrame.this.jPacketTable.scrollRectToVisible(MainAppFrame.this.jPacketTable.getCellRect(MainAppFrame.this.jPacketTable.getRowCount() - 1, 0, true));
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (confirmExitAction.isTrue() && Parser.packets.needsSaving()) {
                saveAsAction.saveTraceAs();
            }
            System.exit(0);
        }
    }
}

